/*-----------------------------------------
   FONTOUT2.C -- Paths for Outlining Fonts
                 (c) Charles Petzold, 1994
  -----------------------------------------*/

#include <windows.h>
#include <string.h>
#include "ezfont.h"

char szClass [] = "FontOut2" ;
char szTitle [] = "FontOut2: Paths for Outlining Fonts" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     static char szString [] = "Outline" ;
     HFONT       hFont ;
     LOGBRUSH    lb ;
     SIZE        size ;

     hFont = EzCreateFont (hdc, "Times New Roman", 1440, 0, 0, TRUE) ;

     SelectObject (hdc, hFont) ;
     SetBkMode (hdc, TRANSPARENT) ;

     GetTextExtentPoint (hdc, szString, strlen (szString), &size) ;

     BeginPath (hdc) ;
     TextOut (hdc, (cxArea - size.cx) / 2, (cyArea - size.cy) / 2,
              szString, strlen (szString)) ;

     EndPath (hdc) ;

     lb.lbStyle = BS_SOLID ;
     lb.lbColor = RGB (255, 0, 0) ;
     lb.lbHatch = 0 ;

     SelectObject (hdc, ExtCreatePen (PS_GEOMETRIC | PS_DOT,
                   GetDeviceCaps (hdc, LOGPIXELSX) / 24,
                   &lb, 0, NULL)) ;

     StrokePath (hdc) ;

     DeleteObject (SelectObject (hdc, GetStockObject (BLACK_PEN))) ;
     SelectObject (hdc, GetStockObject (SYSTEM_FONT)) ;
     DeleteObject (hFont) ;
     }
