#!/usr/bin/perl
# Quick Website News
# Licensed Under the GNU General Public License (see COPYING File)
#
# You are welcome to modify and improve this program as long as any
# improvements are added to the public code base. I would be more than
# pleased to recieve improvements, comment and suggestions by email at qwn@tildemh.com.
# The latest version of these scripts will always be available from my website
# http://www.tildemh.com
#
#                     Copyright (c) 2001 by Mark Howard
#
#       This program is free software; you can redistribute it and/or
#       modify it under the terms of the GNU General Public License as
#       published by the Free Software Foundation; either version 2 of
#       the License, or (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program in the file 'COPYING'; if not, write to
#       the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#       Boston, MA 02111-1307, USA, or contact the author:
# Quick Website News
#
# htmlgen.pm - generates the html files from the news database.


package htmlgen;
use session;
use checksess;
use encode;

&checksess::validsess;

# print html file names as they are created
# show summary
# redirect stderr


sub formattime{
        # @_[0] = e.g. dd/mm/yyyy hh:nn:ss
        @time=gmtime(@_[1]);
# @ time meanings:
# [0]  - sec
# [1]   - min
# 2 hour
# 3 mday
# 4 mon   0..11
# 5 year
# 6 wday    0..6
# 7 yday
#8 isdst
#        $formatted="@time[2]:@time[1]  @time[3]/$month/@time[5]";

        @days=("Mon","Tue","Wed","Thur","Fri","Sat","Sun");
        @ldays=("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday");
        @months=("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sept","Oct","Nov","Dec");
        @lmonths=("January","February","March","April","May","June","July","August","September","October","November","December");
        $formatted=&encode::unencode(@_[0]);
        $formatted =~ s/dddd/@ldays[@time[6]]/g;
        $formatted =~ s/ddd/@days[@time[6]]/g;
        $formatted =~ s/dd/@time[3]/g;
        $formatted =~ s/mmmm/@lmonths[@time[4]]/g;
        $formatted =~ s/mmm/@months[@time[4]]/g;
        $formatted =~ s/mm/@time[4]+1/g;
        $formatted =~ s/yy/@time[5]/g;
        $formatted =~ s/hh/@time[2]/g;
        $formatted =~ s/nn/@time[1]/g;
        $formatted =~ s/ss/@time[0]/g;

#        $formatted =~ s///g;
#        $formatted =~ s///g;

        $formatted;
}


sub editlinks{
# Replaces all sorts of stuff;
        $output=@_[0];
        $output =~ s/\<\!--\#PageNum--\>/$pagenum/g;
        $output =~ s/\<\!--\#QWN_URL--\>/http:\/\/www.tildemh.com/g;
        $output =~ s/\<\!--\#Version--\>/$checksess::version/g;
        $output =~ s/\<\!--\#ProjName--\>/$session::projname/g;
        if ($pagenum==1){
                $p=&encode::unencode("$session::htmldir\/$session::firstfile");
                $output =~ s/\<\!--\#CurrentPage--\>/$p/g;
                $output =~ s/\<\!--\#PrevPage--\>/$p/g;
        }else{
                $filename = &encode::unencode("$session::otherfiles");
                $filename =~ s/\<\!--\#PageNum--\>/$pagenum/g;
                $output =~ s/\<\!--\#CurrentPage--\>/$filename/g;
                if($pagenum==2){
                        $p=&encode::unencode("$session::firstfile");
                        $output =~ s/\<\!--\#PrevPage--\>/$p/g;
                }else{
                        $filename = &encode::unencode("$session::otherfiles");
                        $p=$pagenum-1;
                        $filename =~ s/\<\!--\#PageNum--\>/$p/g;
                        $output =~ s/\<\!--\#PrevPage--\>/$filename/g;
                }
        }
        if($pagenum==$pagecount){
                $filename = &encode::unencode("$session::otherfiles");
                $filename =~ s/\<\!--\#PageNum--\>/$pagenum/g;
                $output =~ s/\<\!--\#NextPage--\>/$filename/g;
        }else{
                $filename = &encode::unencode("$session::otherfiles");
                $p=$pagenum+1;
                $filename =~ s/\<\!--\#PageNum--\>/$p/g;
                $output =~ s/\<\!--\#NextPage--\>/$filename/g;
        }
        # First get the $other string together.
        $other="";
        for ($cur=1; $cur <= $pagecount; $cur++){
                if ($cur==$pagenum){
                        $other.="$cur | ";
                }elsif($cur==1){
                        $p=&encode::unencode("$session::firstfile");
                        $other.="<a href=\"$p\">$cur</a> | ";
                }elsif($cur==$pagecount){
                        $filename = &encode::unencode("$session::otherfiles");
                        $filename =~ s/\<\!--\#PageNum--\>/$cur/g;
                        $other.="<a href=\"$filename\">$cur</a>";
                }else{
                        $filename = &encode::unencode("$session::otherfiles");
                        $filename =~ s/\<\!--\#PageNum--\>/$cur/g;
                        $other.="<a href=\"$filename\">$cur</a> | ";
                }
        }
        $output =~ s/\<\!--\#OtherPages--\>/$other/g;
        $output;
}

sub makehtml{
        &checksess::loadedproj;
        pipe STDERR, STDOP;
        # print "<p>News DB: config/$session::newsdb";
        open(NEWS,"config/$session::newsdb") || print "<p>Unable to open news database - config/$session::newsdb.";
        @news=<NEWS>;
        close(NEWS);

        $newscount=$#news;
        $pagecount=1;
        $newscount -= $session::firstpagecount;
        do{
                $pagecount++;
                $newscount -= $session::otherpagecount;
        }while ($newscount>=0);
        # print "<p>Items: $newscount<p>Pages: $pagecount";

        $count=0;
        $pagenum=1;
        $html=&encode::unencode($session::firsthtmlstart);
        $htmldir=&encode::unencode($session::htmldir);

        print "<ul>";
        do{
                $entry=pop(@news);
                chomp $entry;
                @separated=split(/#/, $entry);
                $separated[1]=&encode::unencode($separated[1]);
                $separated[2]=&encode::unencode($separated[2]);
                $separated[3]=&encode::unencode($separated[3]);

                if ($count<=$session::firstpagecount){
                        $curitem=&encode::unencode($session::firstitemtemplate);
                }else{
                        $curitem=&encode::unencode($session::otheritemtemplate);
                }
                $curitem =~ s/<!--#Content-->/$separated[3]/g;
                $date=&formattime($session::dateformat,$separated[0]);
                $curitem =~ s/<!--#ItemDate-->/$date/g;
                $curitem =~ s/<!--#ItemTitle-->/$separated[2]/g;
                $curitem =~ s/<!--#Author-->/$separated[1]/g;
                 #Option to let dates to be written as you want.
                $html .= $curitem;
                $count++;
                # Check for end of first page
                if ($count==$session::firstpagecount){
                        $html .= &encode::unencode($session::firsthtmlend);
                        $html = &editlinks($html);
                        $filename=&encode::unencode("$htmldir/$session::firstfile");
                        open (HTMLFILE,">$filename") || print "Cannot open file to write to.";
                        print HTMLFILE $html;
                        close HTMLFILE;
                        print "<li><a href=\"$filename\">$filename</a>";
                        #start next
                        $html=&encode::unencode($session::htmlstart);
                        $pagenum++;
                        $html =~ s/\<\!--\#PageNum--\>/$pagenum/g;
                }
                elsif((($count-$session::firstpagecount) / $session::otherpagecount) == int(($count-$session::firstpagecount) / $session::otherpagecount)){
                # Check for end of other pages.
                        $html .= &encode::unencode($session::htmlend);
                        $html = &editlinks($html);
                        $filename = &encode::unencode("$htmldir/$session::otherfiles");
                        $filename =~ s/\<\!--\#PageNum--\>/$pagenum/g;
                        open (HTMLFILE,">$filename") || print "Cannot open file to write to.";
                        print HTMLFILE $html;
                        close HTMLFILE;
                        print "<li><a href=\"$filename\">$filename</a>";
                        #start next
                        $html=&encode::unencode($session::htmlstart);
                        $pagenum++;
                }
        }while $#news>=0;

        # Check Permissions, etc.
        if ($count<$session::firstpagecount){
                $html .= &encode::unencode($session::firsthtmlend);
                $html = &editlinks($html);
                $filename=&encode::unencode("$htmldir/$session::firstfile");
                open (HTMLFILE,">$filename") || print "Cannot open file to write to.";
                print HTMLFILE $html;
                close HTMLFILE;
                print "<li><a href=\"$filename\">$filename</a>";
        }
        else{
                $html .= &encode::unencode($session::htmlend);
                $html = &editlinks($html);
                $filename = &encode::unencode("$htmldir/$session::otherfiles");
                $filename =~ s/\<\!--\#PageNum--\>/$pagenum/g;
                open (HTMLFILE,">$filename") || print "Cannot open file to write to.";
                print HTMLFILE $html;
                close HTMLFILE;
                print "<li><a href=\"$filename\">$filename</a>";
        }
        print "</ul><p>Successfully created $pagenum files with a total of $count news entries.";
}




1;