Attribute VB_Name = "Module6"
'**********************************************************************
'        FILE: dtilib.h
' DESCRIPTION: Header File for DIALOGIC Windows NT library
'
'   Copyright (c) 1991-1996 Dialogic Corp. All Rights Reserved
'
'   THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
'   The copyright notice above does not evidence any actual or
'   intended publication of such source code.
'********************************************************************

'
' Device specific identifiers
 
Global Const DT_IO = &H0           ' I/O interface dev class
Global Const DT_DTI = &H2000       ' DTI device class

Global Const DI_DTI100 = (DT_IO Or DT_DTI Or 100)        ' Device is a DTI/100
Global Const DI_DTI100CH = (DT_IO Or DT_DTI Or DT_TS Or 100) ' Device is a DTI/100 ts

Global Const DI_DTI101 = (DT_IO Or DT_DTI Or 101)        ' Device is a DTI/101
Global Const DI_DTI101CH = (DT_IO Or DT_DTI Or DT_TS Or 101) ' Device is a DTI/101 ts

Global Const DI_DTI124 = (DT_IO Or DT_DTI Or 124)        ' Device is a DTI/124
Global Const DI_DTI124CH = (DT_IO Or DT_DTI Or DT_TS Or 124) ' Device is a DTI/124 ts

Global Const DI_DTI212 = (DT_IO Or DT_DTI Or 212)        ' Device is a DTI/212
Global Const DI_DTI212CH = (DT_IO Or DT_DTI Or DT_TS Or 212) ' Device is a DTI/212 ts

Global Const DI_DTI211 = (DT_IO Or DT_DTI Or 211)        ' Device is a DTI/211
Global Const DI_DTI211CH = (DT_IO Or DT_DTI Or DT_TS Or 211) ' Device is a DTI/211 ts

Global Const TYP_DTI = &H4            ' Digital telephony interface device


'
' Error return codes
 
Global Const DTI_ENOIDLE = &H1       ' DTI/1xx not idle
Global Const DTI_EINTERR = &H2       ' Driver internal error
Global Const DTI_ETIMOUT = &H3       ' Driver timed-out waiting for ACK/NAK
Global Const DTI_ENOMEM = &H4        ' Driver ran out of memory for reply

'
' Defines for Sync mode and async mode
 
Global Const EV_ASYNC = &H8000
Global Const EV_SYNC = &H0

'
' Events for dt_setevtmsk() and dt_getevtmsk()
 
Global Const DTG_T1ERREVT = &H1         ' T1 error event
Global Const DTG_E1ERREVT = DTG_T1ERREVT ' E1 error event
Global Const DTG_SIGEVT = &H2           ' Signaling bit event
Global Const DTG_PDIGEVT = &H3          ' Pulse digit event

'
' Action values for dt_setevtmsk() and dt_settssig() functions
 
Global Const DTA_SETMSK = 0       ' set all mask bits & clear all others
Global Const DTA_ADDMSK = 1       ' set all mask bits & ignore all others
Global Const DTA_SUBMSK = 2       ' clr all mask bits & ignore all others

'
' Enable/disable state flags
 
Global Const DTIS_ENABLE = 1      ' enable DTI feature
Global Const DTIS_DISABLE = 0     ' disable DTI feature

'
' Transmit/receive state flags
 
Global Const BOTH = &H0
Global Const TRANSMIT = &H1
Global Const RECEIVE = &H2

'
' Generic flags to enable or diable features
 
 
Global Const DT_ON = &H1           ' Enable feature
Global Const DT_OFF = &H0          ' disable feature

'
' Signaling mode flags
 
Global Const DTM_SIGINS = 0        ' Inserted signaling mode
Global Const DTM_TRANSP = 1        ' Transparent signaling mode

'
' Signaling bit flags
 
Global Const DTB_ABIT = &H1                     ' A bit flag
Global Const DTB_BBIT = &H2                     ' B bit flag
Global Const DTB_CBIT = &H4                     ' C bit flag
Global Const DTB_DBIT = &H8                     ' D bit flag
Global Const DTC_ABIT = &H10                    ' A bit changed
Global Const DTC_BBIT = &H20                    ' B bit changed
Global Const DTC_CBIT = &H40                    ' C bit changed
Global Const DTC_DBIT = &H80                    ' D bit changed
Global Const DTB_AON = (DTC_ABIT Or DTB_ABIT)   ' A bit SET
Global Const DTB_AOFF = DTC_ABIT                ' A bit CLEAR
Global Const DTB_BON = (DTC_BBIT Or DTB_BBIT)   ' B bit SET
Global Const DTB_BOFF = DTC_BBIT                ' B bit CLEAR
Global Const DTB_CON = (DTC_CBIT Or DTB_CBIT)   ' C bit SET
Global Const DTB_COFF = DTC_CBIT                ' C bit CLEAR
Global Const DTB_DON = (DTC_DBIT Or DTB_DBIT)   ' D bit SET
Global Const DTB_DOFF = DTC_DBIT                ' D bit CLEAR

'
' Idle value flags
 
Global Const IDLE_7F = 0              ' idle value is 7F - T1
Global Const IDLE_FF = 1              ' idle value is FF - T1
Global Const IDLE_54 = IDLE_7F        ' idle value is 54 - E1
Global Const IDLE_D5 = IDLE_FF        ' idle value is D5 - E1
   
'
' Shook state flags
 
Global Const DT_ONHOOK = 0
Global Const DT_OFFHOOK = 1

'
' Timeslot status
 
Global Const DTST_INACTIVE = 0
Global Const DTST_DIAL = 1
Global Const DTST_BUSY = 1
Global Const DTST_WINK = 2
Global Const DTST_WTCALL = 3

'
'-------Alarm handling modes
 
Global Const DTA_NONE = &H0            ' No alarm handling
Global Const DTA_TERM = &H1            ' Terminate alarm handling mode
Global Const DTA_DROP = &H2            ' Drop and insert alarm handling
Global Const DTA_MAX = &H2             ' Maximum value for alarm handling mode

'
' Alarms
 
Global Const YELLOW = &H0            ' Yellow alarm
Global Const BLUE = &H1              ' Blue Alarm
Global Const DEA_REMOTE = YELLOW     ' Remote alarm
Global Const DEA_UNFRAMED1 = BLUE    ' Unframed all 1's
Global Const DEA_SIGNALALL1 = &H2    ' Signalling all 1's
Global Const DEA_DISTANTMF = &H3     ' Distant Multi Frame alarm

'
' Unsolicited DTI event types
 
Global Const DTEV_RCVPDG = (DT_DTI Or &H48)    ' Received a pulse digit
Global Const DTEV_T1ERRC = (DT_DTI Or &H49)    ' T1 error condition event
Global Const DTEV_E1ERRC = DTEV_T1ERRC      ' E1 error condition event == T1 error
Global Const DTEV_COMRSP = (DT_DTI Or &H4A)    ' Successful com test
Global Const DTEV_DATRSP = (DT_DTI Or &H4B)    ' Response to data test
Global Const DTEV_PDDONE = (DT_DTI Or &H4C)    ' Pulse dial complete
Global Const DTEV_SIG = (DT_DTI Or &H4D)       ' Signalling event
Global Const DTEV_RETDIAG = (DT_DTI Or &H4E)   ' Diagnostic complete
Global Const DTEV_WINKCPLT = (DT_DTI Or &H4F)  ' Wink complete
Global Const DTEV_MTFCNCPT = (DT_DTI Or &H50)  ' Multi-tasking func complete
Global Const DTEV_CLKFAIL = (DT_DTI Or &H51)   ' Clock FallBack Event
Global Const DTEV_ERREVT = (DT_DTI Or &HF0)    ' Error condition event
Global Const DTEV_OUTSERVICE = (DT_DTI Or &HF1)  ' Device out of Service event


' Define device class
Global Const DEV_CLASS_DTI = "DTI"

'
'-------Successful return value
 
Global Const EDT_SUCC = &H0         ' Message acknowledged

'
' Driver error codes
 
Global Const EDT_RANGEERR = &H1     ' Bad/overlapping physical mem range
Global Const EDT_TMOERR = &H2       ' Timed out waiting for reply
Global Const EDT_SIZEERR = &H3      ' Message too big or too small
Global Const EDT_BADBRDERR = &H4    ' Board missing or dead
Global Const EDT_NOMEMERR = &H5     ' Can't map or allocate memory
Global Const EDT_BADCMDERR = &H6    ' Invalid or undefined command
Global Const EDT_PARAMERR = &H7     ' Invalid command parameter
Global Const EDT_FWERR = &H8        ' FW returned an error as reply
Global Const EDT_SKIPRPLYERR = &H9  ' A required reply was skipped
Global Const EDT_NOIDLEERR = &HA    ' Timeslot is not in idle state
Global Const EDT_SYSTEM = &HB       ' Unix system error - actual error in errno
Global Const EDT_BADDEV = &HC       ' Bad device error
Global Const EDT_BUSY = &HE         ' Device BUSY
Global Const EDT_OUTSERVICE = &HF   ' Device is OUT_(of)_SERVICE
'
'-------DTI communications protocol error codes
 
Global Const EDT_DATTO = &H91       ' Data reception timed out
Global Const EDT_MBUND = &H92       ' Not enough bytes for a mb req.
Global Const EDT_MBOVR = &H93       ' Message was too long
Global Const EDT_MBTERM = &H94      ' Term byte other than FEH or FFH
Global Const EDT_MBPORT = &H95      ' Rcvd mb data on prt other than 0 or 1
Global Const EDT_MBINV = &H96       ' 1st byte appeared on data port
Global Const EDT_BADPORT = &H97     ' 1st byte appeared on reserved port

'
'-------DTI message processing error codes
 
Global Const EDT_INVCFG = &HA0      ' Invalid cfg area or EEPROM cfg data
Global Const EDT_INVMSG = &HA1      ' Invalid message
Global Const EDT_MBFMT = &HA2       ' Wrong # bytes for desired mb req.
Global Const EDT_MSGCNT = &HA3      ' Count received didn't match actual
Global Const EDT_CHKSUM = &HA4      ' Bad chksum
Global Const EDT_NOTDNLD = &HA5     ' Not downloaded
Global Const EDT_MBIMM = &HA6       ' Received an immediate term
Global Const EDT_INVTS = &HA7       ' Bad timeslot
Global Const EDT_INVBD = &HA8       ' Wrong board
Global Const EDT_SIGINS = &HA9      ' Insertion signaling not enabled
Global Const EDT_BADGLOB = &HAA     ' Bad global parameter number
Global Const EDT_TSASN = &HAB       ' Time slot already assigned
Global Const EDT_BADVAL = &HAC      ' Bad value
Global Const EDT_STARTED = &HAD     ' Can't start when already started
Global Const EDT_PDACT = &HAE       ' Already Pulse Dialing
Global Const EDT_TSBSY = &HAE       ' Time Slot is busy (multi-tasking func)
Global Const EDT_PDOFFHK = &HAF     ' Must be in offhook idle state to pd.
Global Const EDT_PDSIG = &HB0       ' Can't disable insertion when pd
Global Const EDT_MTSIG = &HB0       ' Can't disable insertion when multi-tsking
Global Const EDT_BADCNT = &HB1      ' Count of bytes requested is bad
Global Const EDT_ADDRS = &HB2       ' Bad address
Global Const EDT_SIGTO = &HB3       ' xmt/rcv did not update in time
Global Const EDT_NOTSACS = &HB4     ' Can't use tsacs on this device
Global Const EDT_NOCLK = &HB5       ' No PEB clocking source
Global Const EDT_DTTSTMOD = &HB6    ' In test mode; cannot set board mode
Global Const EDT_BITBSY = &HB7      ' Bit is busy, i.e. already set
Global Const EDT_INVSIGST = &HB8    ' Invalid signalling state
Global Const EDT_NOWTCALL = &HB9    ' Not waiting for a call
Global Const EDT_NOTPEBMODE = &HBA  ' Not in PEB mode
Global Const EDT_WTCALL = &HBB      ' Wait for call in progress
Global Const EDT_DEVIOERR = &HBC    ' Internal Device I/O Control Error

'
'-------SPAN SCSA mode message processing error codes
 
Global Const EDT_SH_LIBBSY = &H51    ' Switching Handler(SH) library is busy
Global Const EDT_SH_BADINDX = &H52   ' Invalid SH index number
Global Const EDT_SH_LIBNOTINIT = &H53 ' SH library has not been initialized
Global Const EDT_SH_NOCLK = &H54     ' Clock fallback failed
Global Const EDT_SH_MISSING = &H56   ' SH is not present
Global Const EDT_SH_BADMODE = &H5A   ' Invalid bus mode
Global Const EDT_SH_BADLCLTS = &H5F  ' Invalid local timeslot number
Global Const EDT_SH_BADTYPE = &H60   ' Invalid local timeslot type
Global Const EDT_SH_BADEXTTS = &H61  ' External ts unsupported at current clk rate
Global Const EDT_SH_LCLTSCNCT = &H62 ' Local ts already connected to SCbus
Global Const EDT_SH_LCLDSCNCT = &H63 ' Local ts already disconnected from SCbus

'
'--------General values
 
Global Const DTV_NUMTS = 24         ' Number of timeslots
Global Const DTV_NUMBD = 4          ' Max number of boards
Global Const DTV_MAXMSG = 48        ' Max bytes in a message

'
'--------Pulse dialing variables
 
Global Const DTV_MAXPDCHR = &H1F    ' Maximum pulse digit chars.
Global Const DTV_FLASHCHR = "&"     ' Default flash char (can be changed)
Global Const DTV_DELAYCHR = ","     ' Delay character (not changable)

'
'-------Board status masks
 
Global Const DTS_DNLDERR = &H1      ' Bit 0 0=ok, 1=err
Global Const DTS_DNLD = &H2         ' Bit 1 0=not dwnld, 1=dwnld
Global Const DTS_DNLDSTRT = &H4     ' Bit 2 0=not started, 1=started
Global Const DTS_CLKBIT1 = &H8      ' Bit 3 - clock source bit 1
Global Const DTS_CLKBIT2 = &H10     ' Bit 4 - clock source bit 0
Global Const DTS_RLOOPBIT = &H20    ' Remote loopback bit 0=off, 1=on

'
'-------The results of run diagnostic on DTI/1xx
 
Global Const DTDE_NOERR = &H0          ' No errors
Global Const DTDE_MEMTST = &H1         ' Memory test failed.
Global Const DTDE_LIUFAIL = &H2        ' Read/Write to LIU failed.
Global Const DTDE_RIMR = &H3           ' Read of RIMR reg. failed.
Global Const DTDE_BVCR = &H4           ' Read of BVCR reg. failed.
Global Const DTDE_ECR = &H5            ' Read of ECR  reg. failed.
Global Const DTDE_CCR = &H6            ' Read of CCR  reg. failed.
Global Const DTDE_RCR = &H7            ' Read of RCR  reg. failed.
Global Const DTDE_TCR = &H8            ' Read of TCR  reg. failed.
Global Const DTDE_TIR1 = &H9           ' Read of TIR1 reg. failed.
Global Const DTDE_TIR2 = &HA           ' Read of TIR2 reg. failed.
Global Const DTDE_TIR3 = &HB           ' Read of TIR3 reg. failed.
Global Const DTDE_TTR1 = &HC           ' Read of TTR1 reg. failed.
Global Const DTDE_TTR2 = &HD           ' Read of TTR2 reg. failed.
Global Const DTDE_TTR3 = &HE           ' Read of TTR3 reg. failed.
Global Const DTDE_RMR1 = &HF           ' Read of RMR1 reg. failed.
Global Const DTDE_RMR2 = &H10          ' Read of RMR2 reg. failed.
Global Const DTDE_RMR3 = &H11          ' Read of RMR3 reg. failed.
Global Const DTDE_XCVRPAT = &H12       ' Read of XCVR reg. failed pattern test.
Global Const DTDE_ROMCHK = &H13        ' Bad rom check sum.

'
'-------The results of run diagnostic on DTI/2xx.
 
Global Const D2DE_NOERR = &H0          ' No errors.
Global Const D2DE_MEMTST = &H1         ' Memory test failed.
Global Const D2DE_LIUFAIL = &H2        ' Read/Write to LIU failed.
Global Const D2DE_XCVRFAIL = &H3       ' Read of XCVR reg. failed pattern test.
Global Const D2DE_ROMCHK = &H4         ' Bad rom check sum.
Global Const D2DE_BRDCFG = &H5         ' Invalid board configuration data.
Global Const D2DE_INVEE = &H6          ' Invalid EEPROM data.

'
'--------Message Mask equates.
 
Global Const DTMM_AON = (DTC_ABIT Or DTB_ABIT)      ' Mask for A went to on msgs.
Global Const DTMM_AOFF = (DTC_ABIT Or &H100)        ' Mask for A went to off msgs.
Global Const DTMM_BON = (DTC_BBIT Or DTB_BBIT)      ' Mask for B went to on msgs.
Global Const DTMM_BOFF = (DTC_BBIT Or &H200)        ' Mask for B went to off msgs.
Global Const DTMM_CON = (DTC_CBIT Or DTB_CBIT)      ' Mask for C went to on msgs.
Global Const DTMM_COFF = (DTC_CBIT Or &H400)        ' Mask for C went to off msgs.
Global Const DTMM_DON = (DTC_DBIT Or DTB_DBIT)      ' Mask for D went to on msgs.
Global Const DTMM_DOFF = (DTC_DBIT Or &H800)        ' Mask for D went to off msgs.
Global Const DTMM_WINK = &H1000                  ' Mask for A bit wink msgs.

'
'--------Masks for timeslot's transmit and receive signalling bits.
 
Global Const DTSG_XMTA = &H1           ' Value of transmit A.
Global Const DTSG_XMTB = &H2           ' Value of transmit B.
Global Const DTSG_XMTC = &H4           ' Value of transmit C.
Global Const DTSG_XMTD = &H8           ' Value of transmit D.
Global Const DTSG_RCVA = &H10          ' Value of receive A.
Global Const DTSG_RCVB = &H20          ' Value of receive B.
Global Const DTSG_RCVC = &H40          ' Value of receive C.
Global Const DTSG_RCVD = &H80          ' Value of receive D.

'
'--------DRP routing masks.
 
Global Const DTDRP_XMT = &H1           ' DRP routing for transmit.
Global Const DTDRP_RCV = &H2           ' DRP routing for receive.

'
'-------Global parameter entry numbers.
 
Global Const DTG_MINPDON = &H0         ' Minimum pulse dial reception on.
Global Const DTG_MINPDOFF = &H1        ' Minimum pulse dial reception off.
Global Const DTG_MAXPDOFF = &H2        ' Maximum interdigit reception delay.
Global Const DTG_MINIPD = &H3          ' Maximum pulse digit reception off.
Global Const DTG_P_MK = &H4            ' Send pulse make time.
Global Const DTG_P_BK = &H5            ' Send pulse break time.
Global Const DTG_P_IDD = &H6           ' Send pulse interdigit delay.
Global Const DTG_PDDLFTIM = &H7        ' Flash time.
Global Const DTG_PDFLASH = &H8         ' Flash character.
Global Const DTG_CABTYPE = &H9         ' Cable type (LIU).
Global Const DTG_OOFMAX = &HA          ' Out of frame errors, maximum (<=15).
Global Const DTG_FECRMAX = DTG_OOFMAX  ' Max FECR error count (<=255)
Global Const DTG_ESECMAX = &HB         ' Extended superframe Err. cnt max <=15.
Global Const DTG_FECSMAX = &HB         ' Frame error count saturation.
Global Const DTG_BPVCMAX = &HC         ' Bipolar violation count max <=255.
Global Const DTG_RDEBON = &HD          ' Receive debounce on value, in 10ms units.
Global Const DTG_RDEBOFF = &HE         ' Receive debounce off value,in 10ms units.
Global Const DTG_PCDEAD = &HF          ' Signalling dead parameter.
Global Const DTG_RCVTOL = &H10         ' Low word of rcv timeout (& ack).
Global Const DTG_RCVTOH = &H11         ' Hi byte of 3 byte rcv & ack timeout.
Global Const DTG_CODESUPR = &H12       ' Suppression value (b8zs,bit7 or tran)
Global Const DTG_WINKMAX = &H13        ' Wink time, in 10ms units.
Global Const DTG_REDTIME = &H14        ' RLOS -> red alarm transition time.
Global Const DTG_RCOVRTM = &H15        ' Red alarm recovery time.
Global Const DTG_PDPSTIM = &H16        ' Pulse dialing pause time
Global Const DTG_WINKMIN = &H17        ' Wink time, in 10ms units.
Global Const DTG_WINKLEN = &H18        ' Wink length(xmt), in 10ms units.
Global Const DTG_PREWINK = &H19        ' Pre-wink delay in 10ms units.
Global Const DTG_CRCENABL = &H1A       ' CRC4 switch (ENABLE or DISABLE)
Global Const DTG_CECRMAX = &H1B        ' Max CRC4 error count <= 255.
Global Const DTG_ECRRSTTM = &H1C       ' Err cnt register reset time in 100ms unts
Global Const DTG_RXTXIDLE = &H1D       ' Receive & Trnsmit idle patterns
Global Const DTG_SEIZESIG = &H1E       ' Line Seizure and Response
Global Const DTG_DVPRMMAX = &H1E       ' Max value of device parameter

Global Const DTG_SETCLK = &H80         ' Set the clock source.
Global Const DTG_SETBDMD = &H81        ' Set the mode.
Global Const DTG_IDLTYP = &H82         ' Set the idle type.
Global Const DTG_DSERRC = &H83         ' Disable error condition mask
Global Const DTG_ENERRC = &H84         ' Enable the error condition mask.

'
'-------T1 Error conditions values.
 
Global Const DTT1_OOF = &H0            ' Out of frame error; count saturation.
Global Const DTT1_LOS = &H1            ' Initial loss of signal detection.
Global Const DTT1_DPM = &H2            ' Driver performance monitor.
Global Const DTT1_BPVS = &H3           ' Bipolar violation count saturation.
Global Const DTT1_ECS = &H4            ' Error count saturation.
Global Const DTT1_RYEL = &H5           ' Receive yellow alarm.
Global Const DTT1_RCL = &H6            ' Receive carrier loss.
Global Const DTT1_FERR = &H7           ' Frame bit error.
Global Const DTT1_B8ZSD = &H8          ' Bipolar eight zero substitution dtct.
Global Const DTT1_RBL = &H9            ' Receive blue alarm.
Global Const DTT1_RLOS = &HA           ' Receive loss of sync.
Global Const DTT1_RED = &HB            ' Got a red alarm condition.

Global Const DTT1_OOFOK = (DTT1_OOF + &H10)     ' Out of frame restored.
Global Const DTT1_LOSOK = (DTT1_LOS + &H10)     ' Signal restored.
Global Const DTT1_DPMOK = (DTT1_DPM + &H10)     ' Driver perf. mon. restored.
Global Const DTT1_BPVSOK = (DTT1_BPVS + &H10)   ' Restored BPVS.
Global Const DTT1_ECSOK = (DTT1_ECS + &H10)     ' Error count saturation restored.
Global Const DTT1_RYELOK = (DTT1_RYEL + &H10)   ' Receive yellow alarm restored.
Global Const DTT1_RCLOK = (DTT1_RCL + &H10)     ' Receive carrier loss restored.
Global Const DTT1_FERROK = (DTT1_FERR + &H10)   ' Frame bit error restored.
Global Const DTT1_B8ZSDOK = (DTT1_B8ZSD + &H10)  ' B8ZS recovered
Global Const DTT1_RBLOK = (DTT1_RBL + &H10)     ' Receive blue alarm restored.
Global Const DTT1_RLOSOK = (DTT1_RLOS + &H10)   ' Receive loss of sync restored.
Global Const DTT1_REDOK = (DTT1_RED + &H10)     ' Red alarm condition recovered.

'
' E1 Error Conditions
 
Global Const DTE1_LOS = &H1         ' Received loss of signal
Global Const DTE1_DPM = &H2         ' Driver performance monitor failure
Global Const DTE1_BPVS = &H3        ' Bipolar violation count saturation.
Global Const DTE1_ECS = &H4         ' Error count saturation
Global Const DTE1_RRA = &H5         ' Received remote alarm
Global Const DTE1_FSERR = &H7       ' Received frame sync error
Global Const DTE1_RUA1 = &H9        ' Received unframed all 1's
Global Const DTE1_RLOS = &HA        ' Received loss of sync
Global Const DTE1_MFSERR = &HC      ' Received multi frame sync error
Global Const DTE1_RSA1 = &HD        ' Received signalling all 1's
Global Const DTE1_RDMA = &HE        ' Received distant multi-frame alarm
Global Const DTE1_CECS = &HF        ' CRC4 error count saturation

Global Const DTE1_LOSOK = &H11      ' Received loss of signal recovered
Global Const DTE1_DPMOK = &H12      ' Driver perf. monitor failure recovered
Global Const DTE1_BPVSOK = &H13     ' Bipolar violation cnt saturation recovered
Global Const DTE1_ECSOK = &H14      ' Error count saturation recovered
Global Const DTE1_RRAOK = &H15      ' Received remote alarm recovered
Global Const DTE1_FSERROK = &H17    ' Received frame sync error recovered
Global Const DTE1_RUA1OK = &H19     ' Received unframed all 1's recovered
Global Const DTE1_RLOSOK = &H1A     ' Received loss of sync recovered
Global Const DTE1_MFSERROK = &H1C   ' Received multi frame sync error recovered
Global Const DTE1_RSA1OK = &H1D     ' Received signalling all 1's recovered
Global Const DTE1_RDMAOK = &H1E     ' Recved. dist. multi-frame alarm recovered
Global Const DTE1_CECSOK = &H1F     ' CRC4 error count saturation recovered

'
'-------Masks for enabling and disabling error conditions.
 
Global Const DTEC_OOF = &H8000        ' OOF condition mask
Global Const DTEC_LOS = &H100         ' Loss of Signal.
Global Const DTEC_DPM = &H200         ' Driver perf. mon. restored.
Global Const DTEC_BPVS = &H80         ' Bipolar violation count saturation.
Global Const DTEC_BVCS = &H80         ' Bipolar violation count saturation.
Global Const DTEC_ECS = &H40          ' Error count saturation.
Global Const DTEC_RYEL = &H20         ' Receive yellow alarm.
Global Const DTEC_RCL = &H10          ' Receive carrier loss.
Global Const DTEC_RCLX = &H10         ' Receive carrier loss.
Global Const DTEC_FERR = &H8          ' Frame bit error.
Global Const DTEC_B8ZSD = &H4         ' Bipolar eight zero subs detection.
Global Const DTEC_RBL = &H2           ' Receive blue alarm.
Global Const DTEC_RLOS = &H1          ' Receive loss of sync.
Global Const DTEC_RED = &H400         ' Red alarm condition

Global Const DEEC_LOS = &H100         ' Loss of signal notification
Global Const DEEC_DPM = &H200         ' Driver performance monitor
Global Const DEEC_BPVS = &H80         ' Bipolar violation count saturation.
Global Const DEEC_ECS = &H40          ' Error count saturation notification
Global Const DEEC_RRA = &H20          ' Receive remote alarm notification
Global Const DEEC_FSERR = &H8         ' Receive frame sync error notification
Global Const DEEC_RUA1 = &H2          ' Receive unframed all 1's notification
Global Const DEEC_RLOS = &H1          ' Receive loss of sync notification
Global Const DEEC_MFSERR = &H800      ' Multi-frame sync error notification
Global Const DEEC_RSA1 = &H1000       ' Receive signalling all 1's notification
Global Const DEEC_RDMA = &H2000       ' Receive distant multi-frame alarm
Global Const DEEC_CECS = &H4000       ' CRC4 error count saturation

'
'-------Suppresion values.
 
Global Const DTSP_TRAN = &H0           ' Suppression is transparent.
Global Const DTSP_B8ZS = &H1           ' Suppression is B8ZS.
Global Const DTSP_BIT7 = &H2           ' Suppression is Bit 7.
Global Const DTSP_MAX = &H2

'
'-------Board modes.
 
Global Const DTMD_NORMAL = &H0         ' Normal mode.
Global Const DTMD_XCVRLB = &H1         ' Tranceiver local loop back mode.
Global Const DTMD_LIULLB = &H2         ' LIU local loop back mode.
Global Const DTMD_LIURLB = &H3         ' LIU remote loop back mode.
Global Const DTMD_MAX = &H3

'
'--------What to do if the pc is dead, bit masks.
 
Global Const DTD_SNDIDLE = &H1         ' Send idle bit (0=NO, 1=YES).
Global Const DTD_IDLEVAL = &H2         ' Idle value (0=7F, 1=FF).
Global Const DTD_STXSIG = &H4          ' Set all xmt signaling (0=NO,1=YES).
Global Const DTD_SIGVAL = &H8          ' Set signaling to (0=0,1=1).

'
'--------Cable line length values for DTI/1xx.
 
Global Const DTLL_2048MHZ = &H0        ' 2.048 Mhz.
Global Const DTLL_MI440 = &H1          ' MAT & ICOT length 220-440 ft.
Global Const DTLL_MI655 = &H2          ' MAT & ICOT length 440-655 ft.
Global Const DTLL_MIANDAP = &H3        ' M & I len. 0-220 & A & P 0-133 ft.
Global Const DTLL_AP266 = &H4          ' ABAM & PIC length 133-266 ft.
Global Const DTLL_AP399 = &H5          ' ABAM & PIC length 266-399 ft.
Global Const DTLL_AP533 = &H6          ' ABAM & PIC length 399-533 ft.
Global Const DTLL_AP655 = &H7          ' ABAM & PIC length 533-655 ft.
Global Const DTLL_MAX = &H8            ' Number of choices.

'
' DTI/211 cable line length values.
 
Global Const DTLL_G703 = &H0           ' CCITT rec. G.703 (2.048MHz).
Global Const DTLL_FCC68 = &H2          ' FCC part 68 option A (CSU).
Global Const DTLL_ANSIT1 = &H3         ' ANSI T1.403 (CSU).
Global Const DTLL_133ABAM = &H3        ' 0-133 feet DSX-1 ABAM (default).
Global Const DTLL_266ABAM = &H4        ' 133-266 feet DSX-1 ABAM.
Global Const DTLL_399ABAM = &H5        ' 266-399 feet DSX-1 ABAM.
Global Const DTLL_533ABAM = &H6        ' 399-533 feet DSX-1 ABAM.
Global Const DTLL_655ABAM = &H7        ' 533-266 feet DSX-1 ABAM.

'
' SPAN-DTI cable line length values.
 
Global Const DTLL_000 = &H0            ' 000-110 ft.
Global Const DTLL_110 = &H1            ' 110-220 ft.
Global Const DTLL_220 = &H3            ' 220-330 ft.
Global Const DTLL_330 = &H2            ' 330-440 ft.
Global Const DTLL_440 = &H6            ' 440-550 ft.
Global Const DTLL_550 = &H7            ' 550-655 ft.
Global Const DTLL_655 = &H5            ' > 655 ft.
Global Const DTLL_SQUARE = &H4         ' Square pulse

'
'--------Clocking values.
 
Global Const DTC_NOCLK = &H0           ' No clocking.
Global Const DTC_LOOP = &H1            ' Loop timing.
Global Const DTC_EXT = &H2             ' Clock from the expansion bus.
Global Const DTC_IND = &H3             ' 1.544 Mhz - independant timing.
Global Const DTC_MAX = &H3             ' Maximum clock value.

'
' Function ids for multitasking function dt_mtfcn()
 
Global Const DEMT_WTCALL = &H2    ' Wait for line seizurer
Global Const DEMT_ABORT = &H1     ' Abort the multitasking function


'
' Type definition for Channel/Timeslot device info structure and its values
 
'
' CT_DEVINFO structure
 
'typedef struct ct_devinfo {
'   unsigned long  ct_prodid;
'   unsigned char  ct_devfamily;
'   unsigned char  ct_devmode;
'   unsigned char  ct_nettype;
'   unsigned char  ct_busmode;
'   unsigned char  ct_busencoding;
'   unsigned char  ct_rfu[7];
'} CT_DEVINFO;

'
' Value defines
 
' device family
Global Const CT_DFD41E = &H2
Global Const CT_DFSPAN = &H3
Global Const CT_DFMSI = &H4

' device mode
Global Const CT_DMNETWORK = &H0
Global Const CT_DMRESOURCE = &H1

' network type
Global Const CT_NTNONE = &H0
Global Const CT_NTT1 = &H1
Global Const CT_NTE1 = &H2
Global Const CT_NTANALOG = &H3
Global Const CT_NTMSI = &H4

' bus mode
Global Const CT_BMPEB = &H0
Global Const CT_BMSCBUS = &H1

' bus encoding
Global Const CT_BEULAW = &H0
Global Const CT_BEALAW = &H1



