/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class Main {
    private static int msgOutputLevel = 2;
    private static File buildFile = new File("build.xml");
    private static PrintStream out = System.out;
    private static Vector targets = new Vector(5);
    private static Properties definedProps = new Properties();

    public static void main(String[] args) {
        int i = 0;
        while (i < args.length) {
            String msg;
            String arg = args[i];
            if (arg.equals("-help") || arg.equals("help")) {
                Main.printUsage();
                return;
            }
            if (arg.equals("-quiet") || arg.equals("-q") || arg.equals("q")) {
                msgOutputLevel = 1;
            } else if (arg.equals("-verbose") || arg.equals("-v") || arg.equals("v")) {
                msgOutputLevel = 3;
            } else if (arg.equals("-logfile") || arg.equals("-l") || arg.equals("l")) {
                try {
                    File logFile = new File(args[i + 1]);
                    ++i;
                    out = new PrintStream(new FileOutputStream(logFile));
                    System.setOut(out);
                    System.setErr(out);
                }
                catch (IOException iOException) {
                    msg = "Cannot write on the specified log file. Make sure the path exists and you have write permissions.";
                    System.out.println(msg);
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    msg = "You must specify a log file when using the -log argument";
                    System.out.println(msg);
                    return;
                }
            } else if (arg.equals("-buildfile") || arg.equals("-file") || arg.equals("-f") || arg.equals("f")) {
                try {
                    buildFile = new File(args[i + 1]);
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    msg = "You must specify a buildfile when using the -buildfile argument";
                    System.out.println(msg);
                    return;
                }
            } else if (arg.startsWith("-D")) {
                String name = arg.substring(2, arg.length());
                String value = null;
                int posEq = name.indexOf("=");
                if (posEq > 0) {
                    value = name.substring(posEq + 1);
                    name = name.substring(0, posEq);
                } else if (i < args.length) {
                    value = args[++i];
                }
                ((Hashtable)definedProps).put(name, value);
            } else {
                if (arg.startsWith("-")) {
                    msg = "Unknown arg: " + arg;
                    System.out.println(msg);
                    Main.printUsage();
                    return;
                }
                targets.addElement(arg);
            }
            ++i;
        }
        if (!buildFile.exists()) {
            System.out.println("Buildfile: " + buildFile + " does not exist!");
            return;
        }
        if (buildFile.isDirectory()) {
            System.out.println("What? Buildfile: " + buildFile + " is a dir!");
            return;
        }
        Main.runBuild();
    }

    private static void printUsage() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("ant [options] [target]" + lSep);
        msg.append("Options: " + lSep);
        msg.append("  -help                  print this message" + lSep);
        msg.append("  -quiet                 be extra quiet" + lSep);
        msg.append("  -verbose               be extra verbose" + lSep);
        msg.append("  -logfile <file>        use given file for log" + lSep);
        msg.append("  -buildfile <file>      use given buildfile" + lSep);
        msg.append("  -D<property>=<value>   use value for given property" + lSep);
        System.out.println(msg.toString());
    }

    private static void runBuild() {
        String msg;
        long startTime = System.currentTimeMillis();
        if (msgOutputLevel >= 2) {
            System.out.println("Buildfile: " + buildFile);
        }
        Project project = new Project(out, msgOutputLevel);
        Enumeration e = ((Hashtable)definedProps).keys();
        while (e.hasMoreElements()) {
            String arg = (String)e.nextElement();
            String value = (String)((Hashtable)definedProps).get(arg);
            project.setUserProperty(arg, value);
        }
        project.setUserProperty("ant.file", buildFile.getAbsolutePath());
        try {
            ProjectHelper.configureProject(project, buildFile);
        }
        catch (BuildException be) {
            msg = "BUILD CONFIG ERROR: ";
            System.out.println(String.valueOf(msg) + be.getMessage());
            be.printStackTrace();
            System.exit(1);
        }
        if (targets.size() == 0) {
            targets.addElement(project.getDefaultTarget());
        }
        try {
            Enumeration en = targets.elements();
            while (en.hasMoreElements()) {
                project.executeTarget((String)en.nextElement());
            }
        }
        catch (BuildException be) {
            msg = "BUILD FATAL ERROR: ";
            System.out.println(String.valueOf(msg) + be.getMessage());
            if (msgOutputLevel > 2) {
                be.printStackTrace();
            }
            System.exit(1);
        }
        long finishTime = System.currentTimeMillis();
        long elapsedTime = finishTime - startTime;
        if (msgOutputLevel >= 2) {
            System.out.println("Completed in " + elapsedTime / 1000L + " seconds");
        }
    }
}

