/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Get
extends Task {
    private String source;
    private String dest;
    private String verbose = "";
    String ignoreErrors = null;

    public void execute() throws BuildException {
        try {
            int length;
            URL url = null;
            try {
                url = new URL(this.source);
            }
            catch (MalformedURLException e) {
                throw new BuildException(e.toString());
            }
            this.project.log("Getting: " + this.source);
            File destF = new File(this.dest);
            FileOutputStream fos = new FileOutputStream(destF);
            InputStream is = null;
            int i = 0;
            while (i < 3) {
                try {
                    is = url.openStream();
                    break;
                }
                catch (IOException ex) {
                    this.project.log("Error opening connection " + ex);
                    ++i;
                }
            }
            if (is == null) {
                this.project.log("Can't get " + this.source + " to " + this.dest);
                if (this.ignoreErrors != null) {
                    return;
                }
                throw new BuildException("Can't get " + this.source + " to " + this.dest);
            }
            byte[] buffer = new byte[102400];
            while ((length = is.read(buffer)) >= 0) {
                fos.write(buffer, 0, length);
                if (!"true".equals(this.verbose)) continue;
                System.out.print(".");
            }
            if ("true".equals(this.verbose)) {
                System.out.println();
            }
            fos.close();
            is.close();
        }
        catch (IOException ioe) {
            this.project.log("Error getting " + this.source + " to " + this.dest);
            if (this.ignoreErrors != null) {
                return;
            }
            throw new BuildException(ioe.toString());
        }
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public void setIgnoreErrors(String v) {
        this.ignoreErrors = v;
    }

    public void setSrc(String d) {
        this.source = d;
    }

    public void setVerbose(String v) {
        this.verbose = v;
    }
}

