/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class RenameExtensions
extends MatchingTask {
    private String fromExtension = "";
    private String toExtension = "";
    private boolean replace = false;
    private File srcDir;

    public void execute() throws BuildException {
        if (this.fromExtension == null || this.toExtension == null || this.srcDir == null) {
            throw new BuildException("srcDir, fromExtension and toExtension attributes must be set!");
        }
        DirectoryScanner ds = this.getDirectoryScanner(this.srcDir);
        String[] files = ds.getIncludedFiles();
        Hashtable renameList = this.scanDir(this.srcDir, files);
        Enumeration e = renameList.keys();
        File fromFile = null;
        File toFile = null;
        while (e.hasMoreElements()) {
            fromFile = (File)e.nextElement();
            toFile = (File)renameList.get(fromFile);
            if (toFile.exists() && this.replace) {
                toFile.delete();
            }
            if (fromFile.renameTo(toFile)) continue;
            throw new BuildException("Rename from: '" + fromFile + "' to '" + toFile + "' failed.");
        }
    }

    private Hashtable scanDir(File srcDir, String[] files) {
        Hashtable<File, File> list = new Hashtable<File, File>();
        int i = 0;
        while (i < files.length) {
            File srcFile = new File(srcDir, files[i]);
            String filename = files[i];
            if (filename.toLowerCase().endsWith(this.fromExtension)) {
                File destFile = new File(srcDir, String.valueOf(filename.substring(0, filename.lastIndexOf(this.fromExtension))) + this.toExtension);
                if (this.replace || !destFile.exists()) {
                    list.put(srcFile, destFile);
                } else {
                    this.project.log("Rejecting file: '" + srcFile + "' for rename as replace is false and file exists", 3);
                }
            } else {
                this.project.log("File '" + filename + "' doesn't match fromExtension: '" + this.fromExtension + "'", 3);
            }
            ++i;
        }
        return list;
    }

    public void setFromExtension(String from) {
        this.fromExtension = from;
    }

    public void setReplace(String replaceString) {
        this.replace = Project.toBoolean(replaceString);
    }

    public void setSrcDir(String srcDirName) {
        this.srcDir = this.project.resolveFile(srcDirName);
    }

    public void setToExtension(String to) {
        this.toExtension = to;
    }
}

