;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
PAGE	,132
	TITLE	BCHRDEV - BIOS char devices

	.LFCOND
	.TFCOND		; /X to cause FALSE conds not to be listed

;
;  BIOS character device driver interface for MS-DOS 2.0
;
; 10/6/82 - bcb
;

	INCLUDE	PARMS.ASM

    IF1
	%OUT	*Pass 1 started*
    ELSE
	%OUT	*Pass 2 started*
    ENDIF

    IF LISTI
	IF1
	%OUT	*Full listing beging generated*
	ENDIF
    ELSE
	IF1
	%OUT	*Include files are not part of listing*
	ENDIF


	.XLIST
    ENDIF

	INCLUDE	DEFDEV.ASM
	INCLUDE	DEFCHR.ASM
	INCLUDE	DEFDOSI.ASM
	INCLUDE	DEF6821.ASM
	INCLUDE	DEFMTR.ASM
	INCLUDE	DEFCONFG.ASM
	INCLUDE	DEFIPAGE.ASM

	.LIST
	PAGE

BIOS_SEG SEGMENT BYTE PUBLIC 'BIOSCODE'

	PUBLIC	CON_INIT
	PUBLIC	CON_IN
	PUBLIC	CON_ICHK
	PUBLIC	CON_ISTAT
	PUBLIC	CON_IFL
	PUBLIC	CON_OUT
	PUBLIC	CON_OSTAT
	PUBLIC	CON_OFL

	PUBLIC	AUX_IN
	PUBLIC	AUX_ICHK
	PUBLIC	AUX_ISTAT
	PUBLIC	AUX_IFL
	PUBLIC	AUX_OUT
	PUBLIC	AUX_OSTAT
	PUBLIC	AUX_OFL

	PUBLIC	PRN_IN
	PUBLIC	PRN_ICHK
	PUBLIC	PRN_ISTAT
	PUBLIC	PRN_IFL
	PUBLIC	PRN_OUT
	PUBLIC	PRN_OSTAT
	PUBLIC	PRN_OFL

	PUBLIC	TIM_IN
	PUBLIC	TIM_OUT
	PUBLIC	TIM_FLG

	EXTRN	BIOS_CONFUNC:FAR
	EXTRN	BIOS_AUXFUNC:FAR
	EXTRN	BIOS_PRNFUNC:FAR
	EXTRN	EXIT_SUCC:NEAR
	EXTRN	EXIT_BUS:NEAR
	EXTRN	EXIT_ERR:NEAR

	EXTRN	RECURLV:WORD
	EXTRN	SAVESS:WORD
	EXTRN	SAVESP:WORD
	EXTRN	BIOS_STACK:BYTE
	EXTRN	BIOS_START:NEAR
	EXTRN	BIOS_DATE:BYTE
	EXTRN	CID_CON:BYTE
	EXTRN	CQ_ZCON:BYTE

	ASSUME	CS:BIOS_SEG,DS:BIOS_SEG,ES:NOTHING,SS:BIOS_SEG

;
; CON_INIT - Set up CON device
;

CON_INIT:
	CLI				; Clear interrupts
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX			; DS = interrupt page
	MOV	SI,(4*DOSI_FCO)		; Fast console output interrupt
	MOV	DS:WORD PTR [SI],OFFSET ISR_FCO
	MOV	DS:WORD PTR [SI+2],CS	; Install the vector
	POP	DS
	STI
	JMP	EXIT_SUCC

;
; Read from console
;

CON_IN:
	LEA	SI,CONJMP	; Jump vector for CON
ALL_IN:
	MOV	CX,CRW_CNT[BX]	; Get byte count
	LES	DI,CRW_TADDR[BX] ; Get transfer addr
ALL_IN1:
	PUSH	DI		; Save regs
ALL_IN2:
	PUSH	SI
	MOV	AH,CHR_READ	; Get read function
	PUSH	CS		; Make call a far call
	CALL	CS:WORD PTR [SI]	; Read char, any errors ?
	POP	SI
	JC	ALL_IN2		;   Yes, try again

	POP	DI
	STOSB			; Store char
	LOOP	ALL_IN1		; Continue until done
	JMP	EXIT_SUCC	; Join common code
	

;
; Non-destructive read
;

CON_ICHK:
	LEA	SI,CONJMP
ALL_ICHK:
	PUSH	BX		; Save BX
	MOV	AH,CHR_LOOK	; Get Look function
	PUSH	CS		; Make call into far call
	CALL	CS:WORD PTR [SI]	; Get copy of char in queue, empty ?
	POP	BX		; Recover BX
	JNC	ALL_ICHK1	;    No, skip
	JMP	EXIT_BUS	;    Yes, show busy
ALL_ICHK1:
	MOV	CIC_CHAR[BX],AL	;    No, store char
	JMP	EXIT_SUCC	; and return

;
; Input status
;

CON_ISTAT:
	CMP	CS:WORD PTR [CID_CON+CID_TYPE],CIDTY_CSP ; Special console?
	JNZ	CON_STA1

;	Console is special device, see if character ready the fast way

	LEA	SI,CQ_ZCON		; SI = pointer to console queue 
	CMP	WORD PTR [SI+CQ_ELMTS],0	; 'ZR' set if no chars
	JZ	ALL_ISTAT1		; Nothing here
	JMP	EXIT_SUCC		; Show ready

;	Not special console, do it the hard way

CON_STA1:
	LEA	SI,CONJMP
ALL_ISTAT:
	MOV	AH,CHR_STATUS	; Get Status function
	MOV	AL,CHR_SFGS	; Get status subfunction
	PUSH	CS		; Make call into far call
	CALL	CS:WORD PTR [SI]   ; Get status (ignore errors)
	TEST	AH,CHRS_RXR	; Does receiver have data ?
	JZ	ALL_ISTAT1	;   No, skip
	JMP	EXIT_SUCC	;   Yes, show it
ALL_ISTAT1:
	JMP	EXIT_BUS

;
; Input flush
;

CON_IFL:
	LEA	SI,CONJMP
ALL_IFL:
	MOV	AH,CHR_CONTROL	; Get control function
	MOV	AL,CHR_CFCI	; Get clear input subfunction
	PUSH	CS		; Make call into far call
	CALL	CS:WORD PTR [SI]	; Clear input (ignore errors)
	JMP	EXIT_SUCC	; Join common code

;
; Write to console
;

CON_OUT:
	CMP	CS:WORD PTR [CID_CON+CID_TYPE],CIDTY_CSP ; Special console?
	JNZ	CON_OUT1

;	Is special console, do it the easy way

	MOV	CX,CRW_CNT[BX]
	LDS	SI,CRW_TADDR[BX]	; CX = count, DS:SI = address
CON_OUT0:
	LODSB
	PUSH	SI
	PUSH	CX
	XOR	AH,AH			; Clear AH flag
	INT	INT_UCRTA		; User interrupt
	OR	AH,AH
	JNZ	CON_OUT0A		; Skip if he says so
	CALL	MTR_SCRT		; Output it fast
CON_OUT0A:
	POP	CX
	POP	SI
	LOOP	CON_OUT0		; Do next one
	JMP	EXIT_SUCC		; All done

;	Not special console, do it the hard way

CON_OUT1:
	LEA	DI,CONJMP
ALL_OUT:
	MOV	CX,CRW_CNT[BX]	; Get byte count
	LDS	SI,CRW_TADDR[BX] ; Get transfer addr
ALL_OUT1:
	LODSB			; Get char
	MOV	AH,CHR_WRITE	; Get read function
	PUSH	SI
ALL_OUT2:
	PUSH	AX		; Save char and function
	PUSH	DI

	PUSH	CS		; Make call a far call
	CALL	CS:WORD PTR [DI]	; Write char, any errors ?

	POP	DI		; Recover AX
	POP	AX
	JC	ALL_OUT2	;   Yes, try again

	POP	SI
	LOOP	ALL_OUT1		; Continue until done

	JMP	EXIT_SUCC	; Join common code

;
;  ISR_FCO - Fast console out interrupt
;
;	AL	=	Character to output
;

ISR_FCO:
	PUSH	AX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	ES

	CMP	CS:WORD PTR [CID_CON+CID_TYPE],CIDTY_CSP ; Special console?
	JNZ	ISR_FCO0		; No, use configurable i/o

;	Is special console, output it very fast

	XOR	AH,AH			; Clear flags
	INT	INT_UCRTA		; User interrupt
	OR	AH,AH
	JNZ	ISR_FCO2		; If he don't want it!
	CALL	MTR_SCRT		; Output the character
ISR_FCO2:
	POP	ES
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	AX
	IRET

;	Not special console, take longer route

ISR_FCO0:
	MOV	AH,CHR_WRITE		; Write the character
ISR_FCO1:
	PUSH	AX
	CALL	FAR PTR BIOS_CONFUNC	; Attempt a write
	POP	AX
	JC	ISR_FCO1		; If errors, try again
	JMP	ISR_FCO2

;
; Output status
;

CON_OSTAT:
	CMP	CS:WORD PTR [CID_CON+CID_TYPE],CIDTY_CSP ; Special console?
	JNZ	CON_OSTAT1	; If not, do it the hard way
	JMP	EXIT_SUCC	; Always ready
CON_OSTAT1:
	MOV	SI,OFFSET CONJMP
ALL_OSTAT:
	MOV	AH,CHR_STATUS	; Get Status function
	MOV	AL,CHR_SFGS	; Get status subfunction
	PUSH	CS		; Make call into far call
	CALL	CS:WORD PTR [SI]	; Get status (ignore errors)
	TEST	AH,CHRS_TXR	; Is transmitter ready to send data
	JZ	ALL_OSTAT1	;   No, skip
	JMP	EXIT_SUCC	;   Yes, show it
ALL_OSTAT1:
	JMP	EXIT_BUS

;
; Flush output 
;

CON_OFL:
	CMP	CS:WORD PTR [CID_CON+CID_TYPE],CIDTY_CSP ; Special console?
	JNZ	CON_OFL1
	JMP	EXIT_SUCC	; Successful exit always
CON_OFL1:
	LEA	SI,CONJMP
ALL_OFL:
	MOV	AH,CHR_CONTROL	; Get control function
	MOV	AL,CHR_CFCO	; Get clear output subfunction
	PUSH	CS		; Make call into far call
	CALL	CS:WORD PTR [SI]	; Clear output (ignore errors)
	JMP	EXIT_SUCC	; Join common code


;
; Read from Aux
;

AUX_IN:
	LEA	SI,AUXJMP
	JMP	ALL_IN

;
; Non-destructive read
;

AUX_ICHK:
	LEA	SI,AUXJMP
	JMP	ALL_ICHK

;
; Input status
;

AUX_ISTAT:
	LEA	SI,AUXJMP
	JMP	ALL_ISTAT

;
; Input flush
;

AUX_IFL:
	LEA	SI,AUXJMP
	JMP	ALL_IFL
;
; Write to AUX
;

AUX_OUT:
	LEA	DI,AUXJMP
	JMP	ALL_OUT

;
; Output status
;

AUX_OSTAT:
	LEA	SI,AUXJMP
	JMP	ALL_OSTAT
;
; Flush output 
;

AUX_OFL:
	LEA	SI,AUXJMP
	JMP	ALL_OFL
;
; Read from PRN
;

PRN_IN:
	LEA	SI,PRNJMP
	JMP	ALL_IN

;
; Non-destructive read
;

PRN_ICHK:
	LEA	SI,PRNJMP
	JMP	ALL_ICHK

;
; Input status
;

PRN_ISTAT:
	LEA	SI,PRNJMP
	JMP	ALL_ISTAT

;
; Input flush
;

PRN_IFL:
	LEA	SI,PRNJMP
	JMP	ALL_IFL
;
; Write to PRN
;

PRN_OUT:
	LEA	DI,PRNJMP
	JMP	ALL_OUT

;
; Output status
;

PRN_OSTAT:
	LEA	SI,PRNJMP
	JMP	ALL_OSTAT

;
; Flush output 
;

PRN_OFL:
	LEA	SI,PRNJMP
	JMP	ALL_OFL
;
; Read time
;

TIM_IN:
	LES	DI,ES:CRW_TADDR[BX]	; Get transfer addr
	MOV	AX,CS
	MOV	DS,AX			; Set up ES:DI as destination
	MOV	SI,OFFSET BIOS_DATE	; Date address

;	ES:DI points to transfer address, DS:SI points to source

TIM_IO:
	MOV	AX,DS:[SI]		; Get first word
	MOV	ES:[DI],AX		; transfer it

;	The final two values are transfered in reverse byte order

	MOV	AX,DS:[SI+2]		; Get next
	XCHG	AL,AH
	MOV	ES:[DI+2],AX		; Reverse and save
	MOV	AX,DS:[SI+4]
	XCHG	AL,AH
	MOV	ES:[DI+4],AX		; Save next
	JMP	EXIT_SUCC

;
; Set time
;

TIM_OUT:
	OR	CS:BYTE PTR TIM_FLG,0FFH	; Set time flag
	LDS	SI,ES:CRW_TADDR[BX]	; Get transfer addr
	MOV	DI,OFFSET BIOS_DATE	; Address of date code
	MOV	AX,CS
	MOV	ES,AX			; DS:SI = from, ES:DI = to
	JMP	SHORT TIM_IO		; Common timer i/o routine

TIM_FLG	DB	0			; !=0 if time changed

CONJMP	DW	OFFSET BIOS_CONFUNC
AUXJMP	DW	OFFSET BIOS_AUXFUNC
PRNJMP	DW	OFFSET BIOS_PRNFUNC

BIOS_SEG	ENDS

	END

