;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
; Definitions for Enhanced programmable communication interface chip 2661-2
;

;	PORT DISPLACEMENTS

EPDATA	EQU	0		;DATA
EPSTAT	EQU	1		;STATUS
EPSYN	EQU	1		;SYN1/SYN2/DLE
EPMODE	EQU	2		;MODE
EPCMD	EQU	3		;COMMAND

;	STATUS REGISTER

EPTXR	EQU	00000001B	;TRANSMITTER READY
EPRXR	EQU	00000010B	;RECEIVER READY
EPTXE	EQU	00000100B	;TRANSMITTER EMPTY
EPDSC	EQU	00000100B	;DATA SET CHANGE
EPPE	EQU	00001000B	;PARITY ERROR
EPOE	EQU	00010000B	;OVERRUN ERROR
EPFE	EQU	00100000B	;FRAME ERROR
EPSD	EQU	00100000B	;SYNC DETECTED
EPDCD	EQU	01000000B	;DATA CARRIER DETECT
EPDSR	EQU	10000000B	;DATA SET READY

;	MODE REGISTER 1

EPMBRF	EQU	00000011B	;MODE AND BAUDRATE FACTOR
EPS1X	EQU	000H		;  SYNCHRONOUS 1X RATE
EPA1X	EQU	001H		;  ASYNCHRONOUS 1X RATE
EPA16X	EQU	002H		;  ASYNCHRONOUS 16X RATE
EPA64X	EQU	003H		;  ASYNCHRONOUS 64X RATE

EPCL	EQU	00001100B	;CHARACTER LENGTH
EPCL5	EQU	000H		;  LENGTH 5
EPCL6	EQU	004H		;  LENGTH 6
EPCL7	EQU	008H		;  LENGTH 7
EPCL8	EQU	00CH		;  LENGTH 8

EPPC	EQU	00010000B	;PARITY CONTROL (0=DISABLED , 1=ENABLED)
EPPT	EQU	00100000B	;PARITY TYPE (0=ODD , 1=EVEN)

EPASBL	EQU	11000000B	;ASYNCHRONOUS STOP BIT LENGTH
EPSB1	EQU	040H		;  LENGTH 1
EPSB15	EQU	080H		;  LENGTH 1.5
EPSB2	EQU	0C0H		;  LENGTH 2

EPSTC	EQU	01000000B	;SYNCHRONOUS TRANSPARENCY CONTROL
				; (0=NORMAL , 1=TRANSPARENT)
EPNSC	EQU	10000000B	;NUMBER OF SYNC CHARACTERS
				; (0=DOUBLE , 1=SINGLE)

;	MODE REGISTER 2

EPBRS	EQU	00001111B	;BAUD RATE SELECTION
EPMR2U	EQU	11110000B	;SEE TEXT
  EPMR2A  EQU	  70H		  ;VALUE FOR ASYNC OPERATION

;	COMMAND REGISTER

EPTXEN	EQU	00000001B	;TRANSMITTER ENABLE
EPDTR	EQU	00000010B	;DATA TERMINAL READY
EPRXEN	EQU	00000100B	;RECEIVER ENABLE
EPSBRK	EQU	00001000B	;SEND BREAK (ASYNC)
EPSDLE	EQU	00001000B	;SEND DLE (SYNC)
EPRESE	EQU	00010000B	;RESET STATUS ERRORS
EPRTS	EQU	00100000B	;REQUEST TO SEND

EPOM	EQU	11000000B	;OPERATING MODE
EPNORM	EQU	000H		;  NORMAL
EPOM1	EQU	040H		;  MODE 1
EPOMLL	EQU	080H		;  LOCAL LOOP BACK
EPOMRL	EQU	0C0H		;  REMOTE LOOP BACK

;	BAUDRATE SELECTION VALUES

EPB455	EQU	0		;45.5
EPB050	EQU	1		;50
EPB075	EQU	2		;75
EPB110	EQU	3		;110
EPB134	EQU	4		;134.5
EPB150	EQU	5		;150
EPB300	EQU	6		;300
EPB600	EQU	7		;600
EPB120	EQU	8		;1200
EPB180	EQU	9		;1800
EPB200	EQU	10		;2000
EPB240	EQU	11		;2400
EPB480	EQU	12		;4800
EPB960	EQU	13		;9600
EPB192	EQU	14		;19200
EPB384	EQU	15		;38400
EPBMAX	EQU	EPB384		;MAX BAUD RATE 
