;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;**	DEFSBC - Define SBC and Superblock
;
;	This file defines the outlay of the SBC
;	and the superblock of the winchester controller
;

SBCSEC	EQU	0		; First sector of SBC
SBCSIZ	EQU	2		; Number of sectors (1k bytes)

SBCTAB	STRUC			; Layout of table at front
SBCTRES	DB	3 DUP (?)	; Reserved
SBCTVER	DB	0		; Version of PART/SBC
SBCTREV	DB	0		; Revision of PART/SBC
SBCTDBS	DB	27 DUP (?)	; Default boot string
SBCTBSA	DB	3 DUP (?)	; FWA of bad sector table A
SBCTBSB	DB	3 DUP (?)	; FWA of bad sector table B
SBCTSBA	DB	3 DUP (?)	; FWA of super block A
SBCTSBB	DB	3 DUP (?)	; FWA of super block B
SBCTSCS	DW	0		; Sector size
SBCTSPT	DW	0		; Sectors/track
SBCTTPC	DW	0		; Tracks/cylinder (number of heads)
SBCTCPV	DW	0		; Cylinders/volume
SBCTSPR	DW	0		; Sectors/region
SBCTNPS	DB	3 DUP (?)	; Number of physical sectors
SBCTNPR	DB	0		; Number of regions - 1
SBCTCSA	DW	0		; CRC for superblock A
SBCTCSB	DW	0		; CRC for superblock B
SBCTCBA	DW	0		; CRC for bad sector table A
SBCTCBB	DW	0		; CRC for bad sector table B
SBCTSDP	DB	12 DUP (?)	; Set Drive for z217 controller
SBCTFUS	DB	3 DUP (?)	; First user sector number
SBCTDAT	DB	6 DUP (0)	; Date partitioned
SBCCRC	DW	?		; CRC of SBC (assuming SBCCRC = 0)
SBCPRK	DW	?		; Parking cylinder if version > 3
	DB	37 DUP (?)	; Reserved for future use
SBCTAB	ENDS

;	Definition of the superblock entry

SBAEPNL	EQU	16		; Length of name entry
SBAEONL	EQU	10		; Length of o/s name
SBAENTL	EQU	30		; Length of an entry

SBAENT	STRUC			; SuperBlock A entry
SBAEPN	DB	SBAEPNL DUP (?)	; Entry name
SBAEON	DB	SBAEONL DUP (?)	; O/S name
SBAEFL	DB	?		; Flag byte
SBAESS	DB	3 DUP (?)	; Starting sector number
SBAENT	ENDS

;	Bit assignments for SBAEFL

SBAEFLNF	EQU	10000000B	; Partition not formatted

