;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
;  Define Functions performed by Disk driver routines
;

DSK_RESET	= 0			; Reset function
DSK_STATUS	= DSK_RESET+1 	; Status function
DSK_READ	= DSK_STATUS+1	; Read function
DSK_WRITE	= DSK_READ+1		; Write function
DSK_VERIFY	= DSK_WRITE+1		; Verify function
DSK_FORMAT	= DSK_VERIFY+1	; Format(write track) function
DSK_STEPIN	= DSK_FORMAT+1	; Step in function
DSK_READTRK	= DSK_STEPIN+1	; Read track function
DSK_GBIOSVEC	= DSK_READTRK+1	; Get BIOS disk vector addr
DSK_MAPDSK	= DSK_GBIOSVEC+1	; Get Logical to physical mapping
DSK_SETFDC	= DSK_MAPDSK+1	; Set FDC bit in drive table
DSK_PREAD	= DSK_SETFDC+1	; Physical read
DSK_ASSIGN	= DSK_PREAD+1		; Assign partition
DSK_PWRITE	= DSK_ASSIGN+1	; Physical write
DSK_DRVNUM	= DSK_PWRITE+1	; Return number of drives
DSK_FMAX	= DSK_DRVNUM		; Max function value



;	
;  Define the disk info block (one is needed for each drive)
;

MAXDSK		= 15		; Maximum number of disks
MAXDSK5		= 2		; Maximum 5 inch drives (0-1)
MAXDSK8		= 4		; Maximum 8 inch drives (2-3)
MAXDSKW		= 8		; Maximum winchester drive (4-7)


DSK_STA		= 0		; Status of last operation
  DSKST_FNERR	  =	0100H	  ; Invalid function 
  DSKST_ORERR	  =	0200H	  ; Improper order of function
  DSKST_DNERR	  =   0300H	  ; Invalid disk number
  DSKST_DTERR	  =	0400H	  ; Invalid disk type
  DSKST_NIERR	  =	0500H	  ; Function not implemented  
  DSKST_NDERR	  =	0600H	  ; No disk in drive
DSK_TYPE	= DSK_STA+2	; Disk type
  DSK_TZ2075	  = 0	  	   ; Z-207 type disk 5"
  DSK_TZ2078	  = DSK_TZ2075+1 ; Z-207 type disk 8" 
  DSK_TZ217	  = DSK_TZ2078+1 ; Z-217 type disk
DSK_LTRK	= DSK_TYPE+1	; Last track
DSK_LOPT	= DSK_LTRK+1	; Last operation
  DSK_OWR	  =	01H	  ; Write was last op
  DSK_ORD	  =	02H	  ; Read was last op
  DSK_ORS	  =	04H	  ; Reset was last op
  DSK_OSI	  =	08H	  ; Step in was last op
  DSK_OFT	  =	10H	  ; Format was last op
  DSK_ORT	  =	20H	  ; Read track was last op
  DSK_OUK	  =	80H	  ; Track is unknown
DSK_FLAG	= DSK_LOPT+1	; Flags
  DSK_FDS	  =	01H	  ; Disk is double sided
  DSK_FFS	  =	02H	  ; Drive can be fast stepped
  DSK_FDP	  =	04H	  ; Disk is 48 tpi and should be double stepped
  DSK_FWP	  =	08H	  ; Disk is software write protected
  DSK_FDC	  =	10H	  ; Force DISK HAS CHANGED one time
  DSK_FSL	  =	20H	  ; Long head settle
  DSK_FRS	  =	40H	  ; Restore fast then slow
  DSK_ASN	  =	80H	  ; No partition assigned
DSK_SEL		= DSK_FLAG+1	; Command to select drive
				;  Flag from superblock for winchester
DSK_RS		= DSK_SEL+1	; Command to reset drive
DSK_SPHI	= DSK_RS+1	; Command to step in
DSK_FMT		= DSK_SPHI+1	; Command to format(write) a track
DSK_RD		= DSK_FMT+1	; Command to read a sector
DSK_WR		= DSK_RD+1	; Command to write a sector
DSK_SK		= DSK_WR+1	; Command to seek to a track
DSK_SERR	= DSK_SK+1	; Number of "soft" errors
DSK_MAXT	= DSK_SERR+2	; Maximum track number of drive
DSK_NRETRY	= DSK_MAXT+1	; Maximum retry count
DSK_SPT		= DSK_NRETRY+1; Sectors per track
				; Sectors per cylinder for winchester
DSK_BPS		= DSK_SPT+1	; Number of bytes per sector
DSK_BPWT	= DSK_BPS+2	; Number of bytes per write track operation
DSK_BPRT	= DSK_BPWT+2	; Number of bytes per read track operation
DSK_DELAY	= DSK_BPRT+2	; Counter value for short delay
DSK_LDELAY	= DSK_DELAY+2	; Counter value for a long delay
DSK_PORT	= DSK_LDELAY+2; Base Port number
DSK_RDT		= DSK_PORT+2	; Read track command
DSK_IMGFLG	= DSK_RDT+1	; Imaginary drive flag
  DSKIF_ID	  = 80H	  ; (0 - real drive; 1 - imaginary drive)
  DSKIF_DV	  = 40H	  ; (0 - disk is not in drive; 1 - disk is in drive)
  DSKIF_NM	  = 20H	  ; (0 - can map imag to drive; 1 - can't)	
  DSKIF_DN	  = 0FH	  ; (Mask for disk in drive)
DSK_TDSEL	= DSK_IMGFLG+1 ; Time to wait before deselecting drive(in 100ths of secs)
DSK_NAME	= DSK_TDSEL+2	; Name for drive
DSK_TIMEOUT	= DSK_NAME+1	; Disk time out value
DSK_SIZE	= DSK_TIMEOUT+2	; Size of DSK
DSK_BSEC	= DSK_TIMEOUT+2	; Base sector
DSKW_NPS	= DSK_BSEC+2	; Number of physical sectors
DSKW_FAT	= DSKW_NPS+2	; Size of FAT in sectors
DSKW_SPAU	= DSKW_FAT+1	; Sectors/allocation unit
DSKW_WUN	= DSKW_SPAU+1	; Unit number
DSKW_BSECH	= DSKW_WUN+1	; Hish sector number of base
DSKW_SIZE	= DSKW_BSECH+1 ; Size of DSK for winchester


; 
;  Define the parameter table passed to the disk drive routines
;

DSKPR_DRIVE	= 0		; Logical drive number
DSKPR_SECTOR	= DSKPR_DRIVE+1 ; Logical sector number
DSKPR_COUNT	= DSKPR_SECTOR+2 ; Sector transfer count
DSKPR_BUFF	= DSKPR_COUNT+2 ; Buffer addr (offset,paragraph)
DSKPR_SIZE	= DSKPR_BUFF+4 ; Size of this thig

